CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	msgFinal text := 'CRIADA';
BEGIN 
IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'v_pdv_meios_pgto_fecha_caixa') THEN 
						 
	DROP VIEW v_pdv_meios_pgto_fecha_caixa;
    RAISE NOTICE 'Viso v_pdv_meios_pgto_fecha_caixa FOI REMOVIDA';                             
    msgFinal := 'RECRIADA'::text;
END IF; 

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20230406
'Job.................:  
'Nome................: v_pdv_meios_pgto_fecha_caixa 
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Criado por..........: 
'Dt Ult Alteraco....: 06/04/2023
'Revisado por........: Marcos Barros
'Alterado por........: Eduardo Costa Moraes

'=======================================================================================
-- FARMAGOI-38891
*/

CREATE VIEW v_pdv_meios_pgto_fecha_caixa
AS SELECT rstemp.cd_emp,
    rstemp.cd_filial,
    rstemp.cd_cx,
    rstemp.cd_mov,
    rstemp.dt_vd,
    rstemp.id_documento,
    rstemp.ds_meio_pgto,
    rstemp.cod_bandeira,
    rstemp.cod_modalidade,
    rstemp.cd_adm_cartao,
    sum(rstemp.vlr_pag) AS vlr_pag,
    rstemp.tp_forma_pgto
   FROM ( SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.cd_mov,
            pdv_vd.dt_vd,
            'CF'::text AS id_documento,
            'DINHEIRO'::text AS ds_meio_pgto,
            pdv_vd.vlr_dinh AS vlr_pag,
            0 AS cod_bandeira,
            ''::text AS cod_modalidade,
            0 AS cd_adm_cartao,
            0 AS tp_forma_pgto
           FROM pdv_vd
          WHERE pdv_vd.vlr_dinh > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.cd_mov,
            pdv_vd.dt_vd,
            'CF'::text AS id_documento,
            'CHEQUES'::text AS ds_meio_pgto,
            pdv_vd.vlr_chqs AS vlr_pag,
            0 AS cod_bandeira,
            ''::text AS cod_modalidade,
            0 AS cd_adm_cartao,
            1 AS tp_forma_pgto
           FROM pdv_vd
          WHERE pdv_vd.vlr_chqs > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.cd_mov,
            pdv_vd.dt_vd,
            'CF'::text AS id_documento,
            CASE
                WHEN substr(pdv_vd_tef.cod_modalidade::text, 1, 2) = '01'::text THEN 'CARTAO DEBITO'::text
            ELSE
                CASE
                    WHEN substr(pdv_vd_tef.cod_modalidade::text, 1, 2) = '02'::text THEN 'CARTAO CREDITO'::text
                ELSE
                    CASE
						WHEN substr(pdv_vd_tef.cod_modalidade::text,1,2) = '07'::text then 'QRLINX PIX'::text
					ELSE
                    	CASE
                        	WHEN pdv_vd_tef.cod_modalidade IS NULL THEN
                        		CASE
                            		WHEN substr(pdv_vd.cod_modalidade::text, 1, 2) = '01'::text THEN 'CARTAO DEBITO'::text
                            	ELSE
                            		CASE
                                		WHEN substr(pdv_vd.cod_modalidade::text, 1, 2) = '02'::text THEN 'CARTAO CREDITO'::text
                                			ELSE 'CREDIARIO'::text
                            		END
                        		END
                        	ELSE 'CREDIARIO'::text
                    	END
                  	END
                END
            END AS ds_meio_pgto,
            COALESCE(pdv_vd_tef.vl_cartao, pdv_vd.vlr_cartao, pdv_vd_tef.vl_cartao) AS vlr_pag,
            pdv_vd_tef.cod_bandeira,
            pdv_vd_tef.cod_modalidade,
            pdv_vd_tef.cd_adm_cartao,
            3 AS tp_forma_pgto
           FROM pdv_vd
             LEFT JOIN pdv_vd_tef ON pdv_vd.cd_emp = pdv_vd_tef.cd_emp AND pdv_vd.cd_filial = pdv_vd_tef.cd_filial AND pdv_vd.cd_vd = pdv_vd_tef.cd_vd
          WHERE pdv_vd.vlr_cartao > 0::numeric AND pdv_vd.st_vd = 0::numeric AND pdv_vd.qt_parc_cred = 0 and coalesce(pdv_vd_tef.vl_cartao, pdv_vd.vlr_cartao, pdv_vd_tef.vl_cartao) > 0
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.cd_mov,
            pdv_vd.dt_vd,
            'CF'::text AS id_documento,
            'CREDIARIO'::text AS ds_meio_pgto,
            pdv_vd_tef.vl_cartao AS vlr_pag,
            pdv_vd_tef.cod_bandeira,
            pdv_vd_tef.cod_modalidade,
            pdv_vd_tef.cd_adm_cartao,
            5 AS tp_forma_pgto
           FROM pdv_vd
             JOIN pdv_vd_tef ON pdv_vd.cd_emp = pdv_vd_tef.cd_emp AND pdv_vd.cd_filial = pdv_vd_tef.cd_filial AND pdv_vd.cd_vd = pdv_vd_tef.cd_vd
          WHERE pdv_vd.vlr_cartao > 0::numeric AND pdv_vd.st_vd = 0::numeric AND pdv_vd.qt_parc_cred > 0
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.cd_mov,
            pdv_vd.dt_vd,
            'CF'::text AS id_documento,
            'VALE COMPRA'::text AS ds_meio_pgto,
            pdv_vd.vlr_tickets AS vlr_pag,
            0 AS cod_bandeira,
            ''::text AS cod_modalidade,
            0 AS cd_adm_cartao,
            6 AS tp_forma_pgto
           FROM pdv_vd
          WHERE pdv_vd.vlr_tickets > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.cd_mov,
            pdv_vd.dt_vd,
            'CF'::text AS id_documento,
            'CONVENIO'::text AS ds_meio_pgto,
            COALESCE(pdv_vd.vlr_conv, 0::numeric) + COALESCE(pdv_vd.vlr_conv_pbm, 0::numeric) AS vlr_pag,
            0 AS cod_bandeira,
            ''::text AS cod_modalidade,
            0 AS cd_adm_cartao,
            4 AS tp_forma_pgto
           FROM pdv_vd
          WHERE (COALESCE(pdv_vd.vlr_conv, 0::numeric) + COALESCE(pdv_vd.vlr_conv_pbm, 0::numeric)) > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.cd_mov,
            pdv_vd.dt_vd,
            'CF'::text AS id_documento,
            'DUPLICATA'::text AS ds_meio_pgto,
            pdv_vd.vlr_dup AS vlr_pag,
            0 AS cod_bandeira,
            ''::text AS cod_modalidade,
            0 AS cd_adm_cartao,
            7 AS tp_forma_pgto
           FROM pdv_vd
          WHERE pdv_vd.vlr_dup > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT pdv_vd.cd_emp,
            pdv_vd.cd_filial,
            pdv_vd.cd_cx,
            pdv_vd.cd_vd,
            pdv_vd.cd_mov,
            pdv_vd.dt_vd,
            'CF'::text AS id_documento,
            'NCC'::text AS ds_meio_pgto,
            pdv_vd.vlr_ncc AS vlr_pag,
            0 AS cod_bandeira,
            ''::text AS cod_modalidade,
            0 AS cd_adm_cartao,
            8 AS tp_forma_pgto
           FROM pdv_vd
          WHERE pdv_vd.vlr_ncc > 0::numeric AND pdv_vd.st_vd = 0::numeric
        UNION ALL
         SELECT rec_n_fisc.cd_emp,
            rec_n_fisc.cd_filial,
            rec_n_fisc.cd_cx,
            rec_n_fisc.cd_ctr AS cd_vd,
            rec_n_fisc.cd_mov,
            rec_n_fisc.dt_cupom AS dt_vd,
            'CNF'::text AS id_documento,
            pgtos.ds_meio_pgto,
            sum(pgtos.vlr_forma_pagto) AS vlr_pag,
            0 AS cod_bandeira,
            ''::text AS cod_modalidade,
            0 AS cd_adm_cartao,
            pgtos.tp_forma_pgto
           FROM pdv_cupom_nao_fiscal rec_n_fisc
             JOIN v_pdv_cupom_nao_fiscal_forma_pgtos_fecha_caixa pgtos ON rec_n_fisc.cd_emp = pgtos.cd_emp AND rec_n_fisc.cd_filial = pgtos.cd_filial AND rec_n_fisc.cd_cx = pgtos.cd_cx AND rec_n_fisc.cd_ctr = pgtos.cd_ctr AND rec_n_fisc.cd_mov = pgtos.cd_mov
          WHERE rec_n_fisc.st_cupom = 0::numeric AND (rec_n_fisc.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric, 4::numeric, 7::numeric]))
          GROUP BY rec_n_fisc.cd_emp, rec_n_fisc.cd_filial, rec_n_fisc.cd_cx, rec_n_fisc.cd_ctr, rec_n_fisc.cd_mov, rec_n_fisc.dt_cupom, pgtos.ds_meio_pgto, pgtos.tp_forma_pgto
        UNION ALL
         SELECT rec_n_fisc.cd_emp,
            rec_n_fisc.cd_filial,
            rec_n_fisc.cd_cx,
            rec_n_fisc.cd_ctr AS cd_vd,
            rec_n_fisc.cd_mov,
            rec_n_fisc.dt_cupom AS dt_vd,
            'CNF'::text AS id_documento,
            pgtos.ds_meio_pgto,
            sum(pgtos.vlr_forma_pagto * '-1'::integer::numeric) AS vlr_pag,
            0 AS cod_bandeira,
            ''::text AS cod_modalidade,
            0 AS cd_adm_cartao,
            pgtos.tp_forma_pgto
           FROM pdv_cupom_nao_fiscal rec_n_fisc
             JOIN v_pdv_cupom_nao_fiscal_forma_pgtos_fecha_caixa pgtos ON rec_n_fisc.cd_emp = pgtos.cd_emp AND rec_n_fisc.cd_filial = pgtos.cd_filial AND rec_n_fisc.cd_cx = pgtos.cd_cx AND rec_n_fisc.cd_ctr = pgtos.cd_ctr AND rec_n_fisc.cd_mov = pgtos.cd_mov
          WHERE rec_n_fisc.st_cupom = 0::numeric AND rec_n_fisc.tp_cupom_nao_fiscal = 5::numeric
          GROUP BY rec_n_fisc.cd_emp, rec_n_fisc.cd_filial, rec_n_fisc.cd_cx, rec_n_fisc.cd_ctr, rec_n_fisc.cd_mov, rec_n_fisc.dt_cupom, pgtos.ds_meio_pgto, pgtos.tp_forma_pgto) rstemp
  GROUP BY rstemp.dt_vd, rstemp.ds_meio_pgto, rstemp.id_documento, rstemp.cd_emp, rstemp.cd_filial, rstemp.cd_cx, rstemp.cd_mov, rstemp.cod_bandeira, rstemp.cod_modalidade, rstemp.cd_adm_cartao, rstemp.tp_forma_pgto
  ORDER BY rstemp.dt_vd, rstemp.ds_meio_pgto;

  RAISE NOTICE 'Viso v_pdv_meios_pgto_fecha_caixa FOI %', msgFinal::varchar;

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();
